/**
 * \file TrkHough.h				
 * \author David Fedele
 */
#ifndef trkhough_h
#define trkhough_h

#include <TObject.h>

#include <TrkStruct.h>
/**
 * \brief Class to describe Hough variables. 
 */
// ==================================================================
class TrkHough : public TObject {

 private:

 public:
  
  Int_t ndblt; ///< number of doublets
  Float_t *alfayz1; //[ndblt]
  Float_t *alfayz2; //[ndblt]
  Int_t *db_cloud;  //[ndblt]

  Int_t ntrpt; ///< number of triplets
  Float_t *alfaxz1; //[ntrpt]
  Float_t *alfaxz2; //[ntrpt]
  Float_t *alfaxz3; //[ntrpt]
  Int_t *tr_cloud;  //[ntrpt]

  Int_t nclouds_yz; ///< number of yz clouds
  Float_t *alfayz1_av; //[nclouds_yz]
  Float_t *alfayz2_av; //[nclouds_yz]
  Int_t *ptcloud_yz;  //[nclouds_yz]

  Int_t nclouds_xz; ///< number of xz clouds
  Float_t *alfaxz1_av; //[nclouds_xz]
  Float_t *alfaxz2_av; //[nclouds_xz]
  Float_t *alfaxz3_av; //[nclouds_xz]
  Int_t *ptcloud_xz;  //[nclouds_xz]

  Int_t nclstr;
  Float_t totaltime;
  Float_t houghtime;
  Float_t fittime;

  TrkHough();
  ~TrkHough();

  void SetFromHoughStruct(cTrkHough *);
  void Clear();
  void Delete();
  
  TrkHough*    GetTrkHough(){return this;}
  
  ClassDef(TrkHough,2);

};

#endif
